"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PayoutsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const expert_entity_1 = require("../experts/expert.entity");
const transaction_entity_1 = require("../transactions/transaction.entity");
let PayoutsService = class PayoutsService {
    constructor(expertRepository, transactionRepository, dataSource) {
        this.expertRepository = expertRepository;
        this.transactionRepository = transactionRepository;
        this.dataSource = dataSource;
    }
    async manualPayout(dto) {
        const { expertId, amount, paymentMethod, bankAccount } = dto;
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            const expert = await queryRunner.manager.findOne(expert_entity_1.Expert, { where: { id: expertId } });
            if (!expert)
                throw new common_1.NotFoundException('Expert not found');
            if (Number(expert.currentWalletBalance) < amount) {
                throw new common_1.BadRequestException('Insufficient wallet balance');
            }
            expert.currentWalletBalance = Number(expert.currentWalletBalance) - amount;
            await queryRunner.manager.save(expert);
            const transaction = this.transactionRepository.create({
                expertId,
                amount,
                type: transaction_entity_1.TransactionType.PAYOUT,
                status: transaction_entity_1.TransactionStatus.SUCCESS,
                metaData: { paymentMethod, bankAccount, mode: 'MANUAL' },
            });
            await queryRunner.manager.save(transaction);
            await queryRunner.commitTransaction();
            return transaction;
        }
        catch (err) {
            await queryRunner.rollbackTransaction();
            throw err;
        }
        finally {
            await queryRunner.release();
        }
    }
    async monthlyPayout(dto) {
        const { expertId, payoutThreshold } = dto;
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            const expert = await queryRunner.manager.findOne(expert_entity_1.Expert, { where: { id: expertId } });
            if (!expert)
                throw new common_1.NotFoundException('Expert not found');
            const balance = Number(expert.currentWalletBalance);
            if (balance < payoutThreshold) {
                throw new common_1.BadRequestException(`Balance ${balance} is below threshold ${payoutThreshold}`);
            }
            const amount = balance;
            expert.currentWalletBalance = 0;
            await queryRunner.manager.save(expert);
            const transaction = this.transactionRepository.create({
                expertId,
                amount,
                type: transaction_entity_1.TransactionType.PAYOUT,
                status: transaction_entity_1.TransactionStatus.SUCCESS,
                metaData: { mode: 'MONTHLY_AUTO', month: dto.month },
            });
            await queryRunner.manager.save(transaction);
            await queryRunner.commitTransaction();
            return transaction;
        }
        catch (err) {
            await queryRunner.rollbackTransaction();
            throw err;
        }
        finally {
            await queryRunner.release();
        }
    }
};
exports.PayoutsService = PayoutsService;
exports.PayoutsService = PayoutsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(expert_entity_1.Expert)),
    __param(1, (0, typeorm_1.InjectRepository)(transaction_entity_1.Transaction)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.DataSource])
], PayoutsService);
//# sourceMappingURL=payouts.service.js.map