"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const session_entity_1 = require("./session.entity");
const user_entity_1 = require("../users/user.entity");
const expert_entity_1 = require("../experts/expert.entity");
const transaction_entity_1 = require("../transactions/transaction.entity");
let SessionsService = class SessionsService {
    constructor(sessionRepository, userRepository, expertRepository, transactionRepository, dataSource) {
        this.sessionRepository = sessionRepository;
        this.userRepository = userRepository;
        this.expertRepository = expertRepository;
        this.transactionRepository = transactionRepository;
        this.dataSource = dataSource;
    }
    async start(dto) {
        const { userId, expertId, sessionFee } = dto;
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            const user = await queryRunner.manager.findOne(user_entity_1.User, { where: { id: userId } });
            if (!user)
                throw new common_1.NotFoundException('User not found');
            const availableCredits = Number(user.max_credits) - Number(user.current_hold);
            if (availableCredits < sessionFee) {
                throw new common_1.BadRequestException('Insufficient credits');
            }
            const session = this.sessionRepository.create({
                userId,
                expertId,
                startTime: new Date(),
                expectedFee: sessionFee,
                status: session_entity_1.SessionStatus.ACTIVE,
            });
            await queryRunner.manager.save(session);
            const holdTransaction = this.transactionRepository.create({
                userId,
                expertId,
                amount: sessionFee,
                type: transaction_entity_1.TransactionType.SESSION_HOLD,
                status: transaction_entity_1.TransactionStatus.SUCCESS,
                referenceId: session.id,
            });
            await queryRunner.manager.save(holdTransaction);
            user.current_hold = Number(user.current_hold) + Number(sessionFee);
            await queryRunner.manager.save(user);
            await queryRunner.commitTransaction();
            return session;
        }
        catch (err) {
            await queryRunner.rollbackTransaction();
            throw err;
        }
        finally {
            await queryRunner.release();
        }
    }
    async adjust(dto) {
        const { sessionId, adjustedFee, deferFee } = dto;
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            const session = await queryRunner.manager.findOne(session_entity_1.Session, { where: { id: sessionId } });
            if (!session)
                throw new common_1.NotFoundException('Session not found');
            if (session.status !== session_entity_1.SessionStatus.ACTIVE)
                throw new common_1.BadRequestException('Session is not active');
            const user = await queryRunner.manager.findOne(user_entity_1.User, { where: { id: session.userId } });
            const oldFee = Number(session.expectedFee);
            const newFee = deferFee ? 0 : adjustedFee;
            const difference = newFee - oldFee;
            session.expectedFee = newFee;
            await queryRunner.manager.save(session);
            const adjustmentTx = this.transactionRepository.create({
                userId: session.userId,
                expertId: session.expertId,
                amount: difference,
                type: transaction_entity_1.TransactionType.ADJUSTMENT,
                status: transaction_entity_1.TransactionStatus.SUCCESS,
                referenceId: sessionId,
                metaData: { deferFee, oldFee, newFee },
            });
            await queryRunner.manager.save(adjustmentTx);
            user.current_hold = Number(user.current_hold) + difference;
            await queryRunner.manager.save(user);
            await queryRunner.commitTransaction();
            return session;
        }
        catch (err) {
            await queryRunner.rollbackTransaction();
            throw err;
        }
        finally {
            await queryRunner.release();
        }
    }
    async end(dto) {
        const { sessionId, actualFee } = dto;
        const queryRunner = this.dataSource.createQueryRunner();
        await queryRunner.connect();
        await queryRunner.startTransaction();
        try {
            const session = await queryRunner.manager.findOne(session_entity_1.Session, { where: { id: sessionId } });
            if (!session)
                throw new common_1.NotFoundException('Session not found');
            if (session.status !== session_entity_1.SessionStatus.ACTIVE)
                throw new common_1.BadRequestException('Session is not active');
            const user = await queryRunner.manager.findOne(user_entity_1.User, { where: { id: session.userId } });
            const expert = await queryRunner.manager.findOne(expert_entity_1.Expert, { where: { id: session.expertId } });
            const holdAmount = Number(session.expectedFee);
            user.current_hold = Number(user.current_hold) - holdAmount;
            user.max_credits = Number(user.max_credits) - actualFee;
            await queryRunner.manager.save(user);
            const commissionRate = 0.10;
            const commission = actualFee * commissionRate;
            const expertEarnings = actualFee - commission;
            if (expert) {
                expert.currentWalletBalance = Number(expert.currentWalletBalance) + expertEarnings;
                await queryRunner.manager.save(expert);
            }
            session.actualFee = actualFee;
            session.endTime = new Date();
            session.status = session_entity_1.SessionStatus.SETTLED;
            await queryRunner.manager.save(session);
            const captureTx = this.transactionRepository.create({
                userId: session.userId,
                expertId: session.expertId,
                amount: actualFee,
                type: transaction_entity_1.TransactionType.SESSION_CAPTURE,
                status: transaction_entity_1.TransactionStatus.SUCCESS,
                referenceId: sessionId,
            });
            await queryRunner.manager.save(captureTx);
            const commissionTx = this.transactionRepository.create({
                expertId: session.expertId,
                amount: commission,
                type: transaction_entity_1.TransactionType.COMMISSION,
                status: transaction_entity_1.TransactionStatus.SUCCESS,
                referenceId: sessionId,
            });
            await queryRunner.manager.save(commissionTx);
            await queryRunner.commitTransaction();
            return session;
        }
        catch (err) {
            await queryRunner.rollbackTransaction();
            throw err;
        }
        finally {
            await queryRunner.release();
        }
    }
};
exports.SessionsService = SessionsService;
exports.SessionsService = SessionsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(session_entity_1.Session)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(2, (0, typeorm_1.InjectRepository)(expert_entity_1.Expert)),
    __param(3, (0, typeorm_1.InjectRepository)(transaction_entity_1.Transaction)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.DataSource])
], SessionsService);
//# sourceMappingURL=sessions.service.js.map